/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.data.DataKeyBase;
import icyllis.flexmark.util.sequence.BasedOptionsHolder;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.BasedSequenceImpl;
import icyllis.flexmark.util.sequence.Range;
import icyllis.flexmark.util.sequence.SequenceUtils;
import icyllis.flexmark.util.sequence.builder.IBasedSegmentBuilder;

public final class SubSequence
extends BasedSequenceImpl {
    @NotNull
    private final CharSequence charSequence;
    @NotNull
    private final SubSequence baseSeq;
    private final int startOffset;
    private final int endOffset;

    @Override
    @NotNull
    public SubSequence getBaseSequence() {
        return this.baseSeq;
    }

    @Override
    public int getOptionFlags() {
        return this.charSequence instanceof BasedOptionsHolder ? ((BasedOptionsHolder)((Object)this.charSequence)).getOptionFlags() : 0;
    }

    @Override
    public boolean allOptions(int options) {
        return this.charSequence instanceof BasedOptionsHolder && ((BasedOptionsHolder)((Object)this.charSequence)).allOptions(options);
    }

    @Override
    public boolean anyOptions(int options) {
        return this.charSequence instanceof BasedOptionsHolder && ((BasedOptionsHolder)((Object)this.charSequence)).anyOptions(options);
    }

    @Override
    public <T> T getOption(@NotNull DataKeyBase<T> dataKey) {
        return this.charSequence instanceof BasedOptionsHolder ? ((BasedOptionsHolder)((Object)this.charSequence)).getOption(dataKey) : dataKey.get(null);
    }

    @Override
    @Nullable
    public DataHolder getOptions() {
        return this.charSequence instanceof BasedOptionsHolder ? ((BasedOptionsHolder)((Object)this.charSequence)).getOptions() : null;
    }

    @Override
    @NotNull
    public CharSequence getBase() {
        return this.charSequence;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    private SubSequence(@NotNull CharSequence charSequence) {
        super(charSequence instanceof String ? charSequence.hashCode() : 0);
        assert (!(charSequence instanceof BasedSequence));
        this.baseSeq = this;
        this.charSequence = charSequence;
        this.startOffset = 0;
        this.endOffset = charSequence.length();
    }

    private SubSequence(@NotNull SubSequence subSequence, int startIndex, int endIndex) {
        super(0);
        assert (startIndex >= 0 && endIndex >= startIndex && endIndex <= subSequence.length()) : String.format("SubSequence must have startIndex >= 0 && endIndex >= startIndex && endIndex <= %d, got startIndex:%d, endIndex: %d", subSequence.length(), startIndex, endIndex);
        this.baseSeq = subSequence;
        this.charSequence = subSequence.charSequence;
        this.startOffset = startIndex;
        this.endOffset = endIndex;
    }

    @Override
    public void addSegments(@NotNull IBasedSegmentBuilder<?> builder) {
        assert (builder.getBaseSequence() == this.baseSeq || builder.getBaseSequence().equals(this.baseSeq));
        builder.append(this.startOffset, this.endOffset);
    }

    @Override
    public int length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    @NotNull
    public Range getSourceRange() {
        return Range.of(this.startOffset, this.endOffset);
    }

    @Override
    public int getIndexOffset(int index) {
        SequenceUtils.validateIndexInclusiveEnd(index, this.length());
        return this.startOffset + index;
    }

    @Override
    public char charAt(int index) {
        SequenceUtils.validateIndex(index, this.length());
        char c = this.charSequence.charAt(index + this.startOffset);
        return c == '\u0000' ? (char)'\ufffd' : (char)c;
    }

    @Override
    @NotNull
    public SubSequence subSequence(int startIndex, int endIndex) {
        SequenceUtils.validateStartEnd(startIndex, endIndex, this.length());
        return this.baseSubSequence(this.startOffset + startIndex, this.startOffset + endIndex);
    }

    @Override
    @NotNull
    public SubSequence baseSubSequence(int startIndex, int endIndex) {
        SequenceUtils.validateStartEnd(startIndex, endIndex, this.baseSeq.length());
        return startIndex == this.startOffset && endIndex == this.endOffset ? this : (this.baseSeq != this ? this.baseSeq.baseSubSequence(startIndex, endIndex) : new SubSequence(this, startIndex, endIndex));
    }

    static BasedSequence create(@Nullable CharSequence charSequence) {
        if (charSequence == null) {
            return BasedSequence.NULL;
        }
        if (charSequence instanceof BasedSequence) {
            return (BasedSequence)charSequence;
        }
        return new SubSequence(charSequence);
    }

    @Deprecated
    public static BasedSequence of(@Nullable CharSequence charSequence) {
        return BasedSequence.of(charSequence);
    }

    @Deprecated
    public static BasedSequence of(@Nullable CharSequence charSequence, int startIndex) {
        return BasedSequence.of(charSequence).subSequence(startIndex, charSequence == null ? 0 : charSequence.length());
    }

    @Deprecated
    public static BasedSequence of(@Nullable CharSequence charSequence, int startIndex, int endIndex) {
        return BasedSequence.of(charSequence).subSequence(startIndex, endIndex);
    }
}

